#pragma once

#include <mail/notsolitesrv/src/context.h>
#include <mail/notsolitesrv/src/errors.h>
#include <mail/notsolitesrv/src/http/client.h>
#include <mail/notsolitesrv/src/user/user.h>
#include <functional>
#include <memory>

namespace NNotSoLiteSrv::NBlackbox {

using TCallback = std::function<void(TErrorCode)>;

void GetUser(
    TContextPtr ctx,
    const std::string& email,
    bool getByUid,
    NUser::TUser& userInfo,
    TCallback cb);

void GetUserWithHttpClient(
    TContextPtr ctx,
    const std::string& email,
    bool getByUid,
    NUser::TUser& userInfo,
    NHttp::TClientPtr httpClient,
    TCallback cb);

using TUserGetter = std::function<decltype(GetUser)>;

using TUsers = std::vector<std::reference_wrapper<NUser::TUser>>;
void GetUsers(
    TContextPtr ctx,
    TUsers&& usersInfo,
    TCallback cb);

void GetUsersWithHttpClient(
    TContextPtr ctx,
    TUsers&& usersInfo,
    NHttp::TClientPtr httpClient,
    TCallback cb);

using TUsersGetter = std::function<decltype(GetUsers)>;

} // namespace NNotSoLiteSrv::NBlackbox
