#pragma once

#include "list.h"
#include <mail/notsolitesrv/src/http/client.h>
#include <mail/notsolitesrv/src/context.h>
#include <mail/notsolitesrv/src/errors.h>
#include <memory>

namespace NNotSoLiteSrv::NBlackWhiteList {

using TCallback = std::function<void(TErrorCode, TListPtr)>;

void LoadLists(TContextPtr ctx, const std::string& uid, TCallback cb);
void LoadListsWithHttpClient(TContextPtr ctx, const std::string& uid, NHttp::TClientPtr httpClient, TCallback cb);
using TListsLoader = std::function<decltype(LoadLists)>;

} // namespace NNotSoLiteSrv::NBlackWhiteList
