#include "list.h"
#include <mail/notsolitesrv/src/util/string.h>
#include <mail/library/utf8/utf8.h>
#include <util/generic/is_in.h>

namespace NNotSoLiteSrv::NBlackWhiteList {

TListItem TListItem::Create(EType type, const std::string& value) {
    return {type, ::NUtil::Utf8ToLower(::NUtil::Utf8Trim(::NUtil::Utf8Sanitized(value)))};
}

void TList::Insert(EType type, const std::string& email) {
    EmailsList.emplace(TListItem::Create(type, email));

    std::string login, domain;
    if (!NUtil::SplitEmail(email, login, domain)) {
        domain = email;
    }

    if (!domain.empty() && login.empty()) {
        DomainsList.emplace(TListItem::Create(type, domain));
    }
}

bool TList::Check(EType type, const std::string& email) const {
    auto sanitized_email = ::NUtil::Utf8ToLower(::NUtil::Utf8Trim(::NUtil::Utf8Sanitized(email)));
    std::string login, domain;
    if (!NUtil::SplitEmail(sanitized_email, login, domain)) {
        return false;
    }

    if (IsIn(EmailsList, TListItem{type, sanitized_email})) {
        return true;
    }

    if (!domain.empty() && IsIn(DomainsList, TListItem{type, domain})) {
        return true;
    }

    return false;
}

std::string TList::ToString(EType type) const {
    std::string ret;

    for (const auto& item: EmailsList) {
        if (item.Type != type) {
            continue;
        }
        if (!ret.empty()) {
            ret.append(", ");
        }

        ret.append(item.Value);
    }

    return ret;
}

std::string TList::ToString() const {
    std::string retv{"Blacklist: ["};

    retv.append(ToString(EType::Black)).append("], ")
        .append("Whitelist: [").append(ToString(EType::White)).append("]");

    return retv;
}

} // namespace NNotSoLiteSrv::NBlackWhiteList
