#pragma once

#include <memory>
#include <set>
#include <string>

namespace NNotSoLiteSrv::NBlackWhiteList {

enum class EType {
    Black,
    White
};

struct TListItem {
    TListItem(EType type, const std::string& value): Type(type), Value(value) {}
    bool operator<(const TListItem& rhs) const { return std::tie(Type, Value) < std::tie(rhs.Type, rhs.Value); }

    static TListItem Create(EType type, const std::string& value);

    EType Type;
    std::string Value;
};

// TODO: обсудить приоритеты списков друг над другом
class TList {
public:
    void Insert(EType type, const std::string& email);
    bool Check(EType type, const std::string& email) const;

    std::string ToString(EType type) const;
    std::string ToString() const;

private:
    using TContainer = std::set<TListItem>;
    TContainer EmailsList;
    TContainer DomainsList;
};

using TListPtr = std::shared_ptr<TList>;

} // namespace NNotSoLiteSrv::NBlackWhiteList
