#pragma once

#include <mail/notsolitesrv/src/config/firstline.h>
#include <mail/notsolitesrv/src/config/furita.h>
#include <mail/notsolitesrv/src/config/httpcall.h>
#include <mail/notsolitesrv/src/config/mdbsave.h>
#include <mail/notsolitesrv/src/config/message.h>
#include <mail/notsolitesrv/src/config/meta_save_op.h>
#include <mail/notsolitesrv/src/config/msearch.h>
#include <mail/notsolitesrv/src/config/msettings.h>
#include <mail/notsolitesrv/src/config/mthr.h>
#include <mail/notsolitesrv/src/config/recognizer.h>
#include <mail/notsolitesrv/src/config/related_uids.h>
#include <mail/notsolitesrv/src/config/session.h>
#include <mail/notsolitesrv/src/config/smtpclient.h>
#include <mail/notsolitesrv/src/config/smtpclient_domain_forward.h>
#include <mail/notsolitesrv/src/config/smtpclient_notify.h>
#include <mail/notsolitesrv/src/config/tupita.h>
#include <mail/notsolitesrv/src/config/user_journal.h>

#include <yplatform/ptree.h>

#include <memory>
#include <string>

namespace NNotSoLiteSrv {

namespace NConfig {

using TFirstlineUptr = std::unique_ptr<TFirstline>;
using TFuritaUptr = std::unique_ptr<TFurita>;
using TMSearchUptr = std::unique_ptr<TMSearch>;
using TMSettingsUptr = std::unique_ptr<TMSettings>;
using TMdbSaveUptr = std::unique_ptr<TMdbSave>;
using TMetaSaveOpUptr = std::unique_ptr<TMetaSaveOp>;
using TTupitaUptr = std::unique_ptr<TTupita>;
using TSessionUptr = std::unique_ptr<TSession>;
using THttpCallUptr = std::unique_ptr<THttpCall>;
using TMessageUptr = std::unique_ptr<TMessage>;
using TMthrUptr = std::unique_ptr<TMthr>;
using TSmtpClientUptr = std::unique_ptr<TSmtpClient>;
using TSmtpClientDomainForwardUptr = std::unique_ptr<TSmtpClientDomainForward>;
using TSmtpClientNotifyUptr = std::unique_ptr<TSmtpClientNotify>;
using TRecognizerUptr = std::unique_ptr<TRecognizer>;
using TRelatedUidsUptr = std::unique_ptr<TRelatedUids>;
using TUserJournalUptr = std::unique_ptr<TUserJournal>;

} // namespace NConfig

struct TConfig {
    explicit TConfig(const yplatform::ptree& ptree);
    ~TConfig();

    NConfig::TFirstlineUptr Firstline;
    NConfig::TFuritaUptr Furita;
    NConfig::TMSearchUptr MSearch;
    NConfig::TMSettingsUptr MSettings;
    NConfig::TMdbSaveUptr MdbSave;
    NConfig::TMetaSaveOpUptr MetaSaveOp;
    NConfig::TMthrUptr Mthr;
    NConfig::TTupitaUptr Tupita;
    NConfig::TSessionUptr Session;
    NConfig::TMessageUptr Message;
    NConfig::THttpCallUptr Blackbox;
    NConfig::THttpCallUptr BWList;
    NConfig::TSmtpClientDomainForwardUptr DomainForward;
    NConfig::TSmtpClientUptr Forward;
    NConfig::TSmtpClientUptr AutoReply;
    NConfig::TSmtpClientNotifyUptr Notify;
    NConfig::TSmtpClientUptr Meta;
    NConfig::TUserJournalUptr UserJournal;
    NConfig::TRecognizerUptr Recognizer;
    NConfig::TRelatedUidsUptr RelatedUids;
};

using TConfigPtr = std::shared_ptr<const TConfig>;

} // namespace NNotSoLiteSrv
