#include "firstline.h"

namespace NNotSoLiteSrv::NConfig {

TFirstline::TFirstline(
    std::uint32_t maxSize,
    const std::string& subscriptionRules,
    const std::string& legacyFirstLineRules,
    const std::string& reactor)
    : MaxSize(maxSize)
    , SubscriptionRules(subscriptionRules)
    , LegacyFirstLineRules(legacyFirstLineRules)
    , Reactor(reactor)
{
}

TFirstline::TFirstline(const yplatform::ptree& ptree) {
    MaxSize = ptree.get("max_size", MaxSize);
    SubscriptionRules = ptree.get("subscription_rules", "");
    LegacyFirstLineRules = ptree.get("legacy_firstline_rules", "");
    Reactor = ptree.get("reactor", "");
}

} // NNotSoLiteSrv::NConfig
