#include "httpcall.h"

namespace NNotSoLiteSrv::NConfig {

THttpCall::THttpCall(const yplatform::ptree& ptree): THttpClient(ptree) {
    Url = ptree.get<std::string>("url");
    TvmServiceName = ptree.get_optional<std::string>("tvm_service_name");
    auto headers = ptree.get_child_optional("add_headers");
    if (headers) {
        for (const auto& [name, value]: *headers) {
            AddHeaders.emplace(name, value.data());
        }
    }
}

} // namespace NNotSoLiteSrv::NConfig
