#include "message.h"
#include <boost/algorithm/string/case_conv.hpp>

namespace NNotSoLiteSrv::NConfig {

namespace {

using Transformer = std::function<std::string(std::string)>;

void ReadSet(const yplatform::ptree& ptree, const std::string& key, std::set<std::string>& set, Transformer transform) {
    auto range = ptree.equal_range(key);
    if (range.first != range.second) {
        set.clear();
        for (auto it = range.first; it != range.second; ++it) {
            set.emplace(transform(it->second.data()));
        }
    }
}

}

TMessage::TMessage(const yplatform::ptree& ptree) {
    SkipAttachWithContentId = ptree.get("skip_attach_with_content_id", SkipAttachWithContentId);
    DoNotStoreMessageRfc822SubpartsHack = ptree.get("do_not_store_message_rfc822_subparts_hack", DoNotStoreMessageRfc822SubpartsHack);
    MaxParts = ptree.get("max_parts", MaxParts);
    ReadSet(ptree, "skip_symbols_for_copy_to_inbox", SkipSymbolsForCopyToInbox, [](auto s) { return s; });
    ReadSet(ptree, "remove_headers", RemoveHeaders,
        [](auto s) {
            return boost::algorithm::to_lower_copy(s);
        });
}

} // namespace NNotSoLiteSrv::NConfig
