#include "msearch.h"

#include <mail/message_types/lib/message_types.h>
#include <util/string/cast.h>
#include <yplatform/ptree.h>

#include <boost/range/iterator_range.hpp>
#include <boost/range/adaptor/transformed.hpp>

#include <set>

namespace NNotSoLiteSrv::NConfig {

namespace {

std::set<NMail::EMessageType> ReadMessageTypes(const yplatform::ptree& ptree, const std::string& key) {
    auto range = ptree.equal_range(key);
    auto types = boost::make_iterator_range(range.first, range.second) | boost::adaptors::transformed([](const auto& node) {
        return FromString<NMail::EMessageType>(node.second.data());
    });

    return {types.begin(), types.end()};
}

} // namespace

TMSearch::TMSearch(const yplatform::ptree& ptree) {
    ClusterClient = ptree.get("cluster_client", ClusterClient);
    Service = ptree.get("service", Service);
    TvmModule = ptree.get("tvm_module", TvmModule);
    UseTvm = ptree.get("use_tvm", UseTvm);
    MessageTypes = ReadMessageTypes(ptree, "message_types");
}

} // namespace NNotSoLiteSrv::NConfig
