#include "smtpclient.h"

namespace NNotSoLiteSrv::NConfig {

TOnSmtpError FromString(const std::string& str) {
    if (str == "fail") {
        return TOnSmtpError::Fail;
    }
    if (str == "fallback_to_file") {
        return TOnSmtpError::FallbackToFile;
    }
    throw std::runtime_error("Unknown 'on_error' value '" + str + "'");
}

TSmtpClient::TSmtpClient(const yplatform::ptree& ptree) {
    Remote = ymod_smtpclient::SmtpPoint::fromString(ptree.get<std::string>("remote"));
    Attempts = ptree.get("attempts", Attempts);
    DataTimeout = ptree.get("data_timeout", DataTimeout);
    ConnectTimeout = ptree.get("connect_timeout", ConnectTimeout);
    UseSSL = ptree.get("use_ssl", UseSSL);
    SendEnvid = ptree.get("send_envid", SendEnvid);
    AllowPartialSend = ptree.get("allow_partial_send", AllowPartialSend);

    auto onError = ptree.get_optional<std::string>("on_error");
    if (onError) {
        OnError = FromString(*onError);
    }
    FileSpoolDir = ptree.get("file_spool_dir", FileSpoolDir);
    if (OnError == TOnSmtpError::FallbackToFile && FileSpoolDir.empty()) {
        throw std::runtime_error("Empty file_spool_dir, but on_error == fallback_to_file");
    }
    MaxRecipients = ptree.get("max_recipients", MaxRecipients);
}

} // namespace NNotSoLiteSrv::NConfig
