#pragma once

#include <mail/notsolitesrv/src/types/time.h>
#include <ymod_smtpclient/smtp_point.h>
#include <yplatform/ptree.h>

namespace NNotSoLiteSrv::NConfig {

enum class TOnSmtpError {
    FallbackToFile,
    Fail
};

struct TSmtpClient {
    explicit TSmtpClient(const yplatform::ptree& ptree);
    virtual ~TSmtpClient() = default;

    ymod_smtpclient::SmtpPoint Remote;
    int Attempts = 2;
    NTimeTraits::TDuration DataTimeout = NTimeTraits::TDuration::max();
    NTimeTraits::TDuration ConnectTimeout = NTimeTraits::TDuration::max();
    bool UseSSL = false;
    bool SendEnvid = true;
    bool AllowPartialSend = false;
    TOnSmtpError OnError = TOnSmtpError::Fail;
    std::string FileSpoolDir;
    ssize_t MaxRecipients = 25;
};

} // namespace NNotSoLiteSrv::NConfig
