#pragma once

#include "config.h"
#include <mail/notsolitesrv/src/tskv/log.h>
#include <yplatform/task_context.h>

namespace NNotSoLiteSrv {

using TTaskContext = yplatform::task_context;
using TTaskContextPtr = yplatform::task_context_ptr;

class TContext {
public:
    explicit TContext(TConfigPtr cfg, const std::string& sessionId = "", const std::string& envelopeId = "");

    void SetSessionId(const std::string& sessionId = "");
    void SetEnvelopeId(const std::string& envelopeId = "");
    const std::string& GetSessionId() const { return SessionId; }
    const std::string& GetEnvelopeId() const { return EnvelopeId; }
    const std::string& GetFullSessionId() const { return FullSessionId; }

    auto GetLogger() const {
        return logdog::bind(
            MakeNslsLogger(),
            log::uniq_id=GetFullSessionId(),
            log::connection_id=GetSessionId(),
            log::envelope_id=GetEnvelopeId());
    }

    TConfigPtr GetConfig() { return Config; }
    TTaskContextPtr GetTaskContext(const std::string& suffix = "");

private:
    void UpdateFullSessionId() {
        FullSessionId = SessionId + "-" + EnvelopeId;
    }

private:
    std::string SessionId;
    std::string EnvelopeId;
    std::string FullSessionId;

    TConfigPtr Config;
};

using TContextPtr = std::shared_ptr<TContext>;

} // namespace NNotSoLiteSrv
