#include "firstline.h"

#include <mail/notsolitesrv/src/errors.h>
#include <mail/notsolitesrv/src/tskv/log.h>
#include <mail/library/utf8/utf8.h>

#include <boost/asio.hpp>

namespace NNotSoLiteSrv::NFirstline {

static const std::string FIRSTLINE{"FIRSTLINE"};

TFirstline::TFirstline(NImpl::TFirstlinePtr firstlineImpl, boost::asio::io_context& ioContext)
    : FirstlineImpl{std::move(firstlineImpl)}
    , Io{ioContext}
{
}

void TFirstline::Firstline(TContextPtr ctx, TFirstlineRequest request,
        TFirstlineCallback callback, boost::asio::io_context& ioContext) const
{
    auto generateFirstline = [
        self = shared_from_this(),
        ctx = std::move(ctx),
        request = std::move(request),
        callback = std::move(callback),
        executor = ioContext.get_executor()
    ]() {
        try {
            auto firstline = self->FirstlineImpl->GenerateFirstline(request);
            boost::asio::post(executor, [=, firstline = std::move(firstline)]() {
                callback({}, TFirstlineResponse{firstline});
            });
        } catch (const std::exception& ex) {
            NSLS_LOG_ERROR(ctx, log::message = "failed to generate firstline", log::exception = ex,
                log::where_name = FIRSTLINE);
            boost::asio::post(executor, [=]() {
                callback(make_error_code(EError::FirstlineError), {});
            });
        }
    };
    boost::asio::post(Io, generateFirstline);
}

} // namespace NNotSoLiteSrv::NFirstline
