#pragma once

#include "ifirstline.h"
#include "ifirstline_impl.h"

#include <mail/notsolitesrv/src/firstline/types/request_impl.h>
#include <mail/notsolitesrv/src/types/common.h>

namespace NNotSoLiteSrv::NFirstline {

class TFirstline : public IFirstline, public std::enable_shared_from_this<TFirstline> {
public:
    TFirstline(NImpl::TFirstlinePtr firstlineImpl, boost::asio::io_context& ioContext);

    void Firstline(TContextPtr ctx, TFirstlineRequest request,
        TFirstlineCallback callback, boost::asio::io_context& ioContext) const override;

private:
    const NImpl::TFirstlinePtr FirstlineImpl;
    boost::asio::io_context& Io;
};

} // namespace NNotSoLiteSrv::NFirstline
