#pragma once

#include "ifirstline_impl.h"

#include <mail/notsolitesrv/lib/firstline/types.h>
#include <mail/notsolitesrv/src/config.h>

namespace NNotSoLiteSrv::NFirstline::NImpl {

struct TFirstline : public IFirstline {
    TFirstline(const NConfig::TFirstlineUptr& config);

    std::string GenerateFirstline(const TFirstlineRequest& request) const override;

private:
    const std::uint32_t FirstLineMaxSize;
    const NLib::TLegacyFirstLinePtr LegacyFirstLine;
    const NLib::TSubscriptionSourcePtr SubscriptionSource;
};

} // namespace NNotSoLiteSrv::NFirstline::NImpl
