#pragma once

#include <mail/notsolitesrv/src/context.h>
#include <mail/notsolitesrv/src/errors.h>
#include <mail/notsolitesrv/src/firstline/types/request.h>
#include <mail/notsolitesrv/src/firstline/types/response.h>

#include <boost/asio.hpp>

#include <functional>
#include <memory>
#include <optional>
#include <string>

namespace NNotSoLiteSrv::NFirstline {

using TFirstlineResult = std::optional<TFirstlineResponse>;
using TFirstlineCallback = std::function<void(TErrorCode, TFirstlineResult)>;

struct IFirstline {
    virtual ~IFirstline() = default;

    virtual void Firstline(TContextPtr ctx, TFirstlineRequest request,
        TFirstlineCallback callback, boost::asio::io_context& ioContext) const = 0;
};

using TFirstlinePtr = std::shared_ptr<IFirstline>;

} // NNotSoLiteSrv::NFirstline
