#pragma once

#include "iclient.h"

#include <mail/notsolitesrv/src/context.h>
#include <mail/notsolitesrv/src/http/types.h>
#include <mail/notsolitesrv/src/http/util.h>
#include <mail/notsolitesrv/src/tskv/log.h>
#include <mail/notsolitesrv/src/types/common.h>

#include <utility>

namespace NNotSoLiteSrv::NFurita {

class TFuritaClient : public IFuritaClient {
public:
    TFuritaClient(TContextPtr ctx, TClusterCallPtr clusterCall, TTvmModulePtr tvmModule);

    void List(boost::asio::io_context& ioContext, TUid uid, TListCallback callback) const override;
    void Get(boost::asio::io_context& ioContext, TOrgId orgId, TGetCallback callback) const override;

private:
    yhttp::request MakeListRequest(const TUid uid) const;
    void ProcessListResponse(TErrorCode errorCode, THttpResponse response, TListCallback callback) const;
    TListResult ParseListResponse(const std::string responseBody) const;

    yhttp::request MakeGetRequest(TOrgId orgId) const;
    void ProcessGetResponse(TErrorCode errorCode, THttpResponse response, TGetCallback callback) const;
    TGetResult ParseGetResponse(std::string responseBody) const;

    std::string GetTvmServiceTicket() const;

    void ProcessListError(TErrorCode errorCode, THttpResponse response, TListCallback callback) const;
    void ProcessGetError(TErrorCode errorCode, THttpResponse response, TGetCallback callback) const;

    const TContextPtr Ctx;
    const TClusterCallPtr ClusterCall;
    const TTvmModulePtr TvmModule;
};

}
