#pragma once

#include <mail/notsolitesrv/src/errors.h>
#include <mail/notsolitesrv/src/furita/types/response.h>
#include <mail/notsolitesrv/src/types/common.h>

#include <boost/asio.hpp>

#include <functional>
#include <memory>
#include <optional>
#include <string>

namespace NNotSoLiteSrv::NFurita {

using TListResult = std::optional<TFuritaListResponse>;
using TListCallback = std::function<void(TErrorCode, TListResult)>;
using TGetResult = std::optional<TFuritaGetResponse>;
using TGetCallback = std::function<void(TErrorCode, TGetResult)>;

class IFuritaClient {
public:
    virtual ~IFuritaClient() = default;

    virtual void List(boost::asio::io_context& ioContext, TUid uid, TListCallback callback) const = 0;
    virtual void Get(boost::asio::io_context& ioContext, TOrgId orgId, TGetCallback callback) const = 0;
};

using TFuritaClientPtr = std::shared_ptr<IFuritaClient>;

}
