#pragma once

#include <mail/notsolitesrv/src/types/common.h>

#include <cstdint>
#include <optional>
#include <string>
#include <vector>

namespace NNotSoLiteSrv::NFurita {

struct TFuritaAction {
    bool Verified;
    std::optional<std::string> Parameter;
    std::string Type;
};

struct TFuritaRule {
    std::string Id;
    int64_t Priority;
    std::string Query;
    bool Enabled;
    bool Stop;
    std::vector<TFuritaAction> Actions;
};

struct TFuritaListResponse {
    std::vector<TFuritaRule> Rules;
};

struct TFuritaDomainRuleScope {
    std::string Direction;
};

struct TFuritaDomainActionData {
    std::optional<std::string> Email;
};

struct TFuritaDomainAction {
    std::string Action;
    std::optional<TFuritaDomainActionData> Data;
};

struct TFuritaDomainRule {
    std::optional<bool> Terminal;
    TFuritaDomainRuleScope Scope;
    std::string ConditionQuery;
    std::vector<TFuritaDomainAction> Actions;
};

struct TFuritaGetResponse {
    std::vector<TFuritaDomainRule> Rules;
    uint64_t Revision;
};

}
