#pragma once

#include <mail/notsolitesrv/src/config/httpcall.h>
#include <mail/notsolitesrv/src/context.h>
#include <mail/notsolitesrv/src/errors.h>

#include <ymod_httpclient/call.h>
#include <ymod_httpclient/url_encode.h>
#include <ymod_tvm/module.h>
#include <yplatform/zerocopy/segment.h>

#include <boost/optional/optional_fwd.hpp>

#include <memory>
#include <string>

namespace NNotSoLiteSrv::NHttp {

using THeaders = ymod_httpclient::headers_dict;
using TResponse = yhttp::response;

void AppendUriParams(std::string& uri, const std::string& paramsStr);

inline std::string UrlEncode(
    const ymod_httpclient::params_initializer_list& params,
    const char prefix = '\0')
{
    return ymod_httpclient::url_encode(params, prefix);
}

class IClient {
public:
    using TCallback = std::function<void(TErrorCode, const TResponse&)>;

    virtual ~IClient() = default;

    virtual void Get(const std::string& url, const THeaders& headers, TCallback cb) = 0;
    virtual void Get(const std::string& url, TCallback cb) = 0;

    virtual void Head(const std::string& url, const THeaders& headers, TCallback cb) = 0;
    virtual void Head(const std::string& url, TCallback cb) = 0;

    virtual void Post(
        const std::string& url,
        const std::string& body,
        const THeaders& headers,
        TCallback cb) = 0;

    virtual void Post(
        const std::string& url,
        const std::string& body,
        TCallback cb) = 0;

    virtual void Post(
        const std::string& url,
        const yplatform::zerocopy::segment& zcBody,
        const THeaders& headers,
        TCallback cb) = 0;

    virtual void Post(
        const std::string& url,
        const yplatform::zerocopy::segment& zcBody,
        TCallback cb) = 0;
};

using TClientPtr = std::shared_ptr<IClient>;

TClientPtr CreateClientByName(
    TContextPtr ctx,
    const std::string& service,
    const NConfig::THttpCall& cfg,
    const std::string& name);

TClientPtr CreateClient(
    TContextPtr ctx,
    const std::string& service,
    const NConfig::THttpCall& cfg,
    std::shared_ptr<yhttp::call> yhttp,
    std::shared_ptr<ymod_tvm::tvm2_module> ytvm);

} // namespace NNotSoLiteSrv::NHttp
