#pragma once

#include <mail/notsolitesrv/src/context.h>
#include <ymod_webserver/methods.h>
#include <ymod_webserver/server.h>
#include <memory>
#include <string>
#include <vector>

namespace NNotSoLiteSrv::NHttp {

using EMethod = ymod_webserver::methods::http_method;
using ECode = ymod_webserver::codes::code;
using THttpStreamPtr = ymod_webserver::http::stream_ptr;

class IHandler: public std::enable_shared_from_this<IHandler> {
public:
    using TCallback = std::function<void()>;
    virtual ~IHandler() = default;

    virtual std::string Name() const = 0;
    virtual std::vector<std::string> Paths() const = 0;
    virtual std::vector<EMethod> AllowedMethods() const = 0;
    virtual void Execute(TContextPtr ctx, THttpStreamPtr stream, TCallback callback) = 0;
    void Run(TContextPtr ctx, THttpStreamPtr stream);
    void OnRequestDone(TContextPtr ctx);
};

using THandlerPtr = std::shared_ptr<IHandler>;

} // namespace NNotSoLiteSrv::NHttp
