#include "dryrun.h"

#include <mail/notsolitesrv/src/http/types/reflection/response.h>

#include <yamail/data/serialization/yajl.h>

#include <optional>
#include <utility>

namespace NNotSoLiteSrv::NHttp::NImpl {

void DryRun(TStoreRequest request, TCallback callback) {
    TStoreResponse response;
    for (auto& requestRecipient : request.Recipients) {
        TStoreResponseRecipient responseRecipient {
            .Email = std::move(requestRecipient.Email),
            .Uid = std::move(requestRecipient.Uid),
            .IsLocal = std::move(requestRecipient.IsLocal),
            .Notify = requestRecipient.Notify,
            .DeliveryResult = {TDeliveryResult{.Mid = "1234", .ImapId = "4321"}},
            .Status = "stored"
        };

        response.Recipients.emplace_back(std::move(responseRecipient));
    }

    return callback(EError::Ok, yamail::data::serialization::toJson(response).str());
}

}
