#include "new_emails.h"
#include <mail/notsolitesrv/src/tskv/logger.h>
#include <mail/ymod_mds/src/client.h>
#include <yplatform/coroutine.h>
#include <yplatform/find.h>
#include <yplatform/log/contains_logger.h>
#include <util/generic/is_in.h>

namespace NNotSoLiteSrv::NHttp::NImpl {

namespace NDetail {

#include <yplatform/yield.h>
class TFiller {
public:
    using TYieldCtx = yplatform::yield_context<TFiller>;
    TFiller(
        TContextPtr ctx,
        const NNewEmails::TDataProvider& provider,
        TNewRecipients& newRecipients,
        NNewEmails::TProcessor::TSenderCallback callback
    )
        : Ctx(ctx)
        , DataProvider(provider)
        , NewRecipients(newRecipients)
        , Callback(std::move(callback))
        , Where(DataProvider.GetWherePrefix())
    {}

    void operator()(TYieldCtx yctx, TErrorCode errc = {}) {
        try {
            reenter (yctx) {
                Recipients = DataProvider.GetRecipients();
                if (Recipients.empty()) {
                    yield break;
                }

                yield StoreInMds(yctx);
                if (errc) {
                    yield break;
                }

                MakeResponseRecpients();
            }

            if (yctx.is_complete()) {
                return Callback(errc);
            }
        } catch (const std::exception& e) {
            return Callback(EError::DeliveryInternal);
        }
    }

private:
    void MakeResponseRecpients() {
        auto recipients = DataProvider.GetRecipients();
        NSLS_LOG_CTX_DEBUG(
            logdog::message="Got " + std::to_string(recipients.size()) + " new recipients",
            logdog::where_name=Where);
        for (const auto& rcpt: recipients) {
            TNewRecipient ret;
            ret.Email = rcpt.Email;
            ret.Uid = rcpt.Uid;
            ret.Stid = Stid;
            ret.IsLocal = DataProvider.ForceLocal() ? "yes" : "unknown";
            ret.Notifies = rcpt.NotifyMode;
            NewRecipients.emplace_back(std::move(ret));
        }
    }

    void StoreInMds(TYieldCtx yctx) {
        auto mgClient = yplatform::find<NMds::TClient>("ymod_mds");
        mgClient->Put(
            Ctx->GetTaskContext(Where),
            NMds::MakeStid(Recipients.front().Uid, Recipients.size() > 1),
            DataProvider.GetMessage(),
            DataProvider.NeedPermanentStid() ? NMds::NS_MAIL : NMds::NS_TMP,
            [this, yctx](TErrorCode ec, const std::string& stid) {
                if (ec) {
                    NSLS_LOG_CTX_ERROR(
                        logdog::message="mulcagate error",
                        logdog::error_code=ec,
                        logdog::where_name=Where);
                } else {
                    NSLS_LOG_CTX_DEBUG(
                        logdog::message="put successful, stid=" + stid + " , mulcaid=" + stid,
                        logdog::where_name=Where);
                    Stid = stid;
                }
                return yctx(ec);
            });
    }

private:
    TContextPtr Ctx;
    const NNewEmails::TDataProvider& DataProvider;
    TNewRecipients& NewRecipients;
    NNewEmails::TProcessor::TSenderCallback Callback;

    NNewEmails::TRecipients Recipients;
    std::string Stid;
    std::string Where;
};
#include <yplatform/unyield.h>

} // namespace NDetail


void AsyncFillResponseWithNewEmails(
    TContextPtr ctx,
    const NNewEmails::TDataProvider& provider,
    TNewRecipients& newRecipients,
    NNewEmails::TProcessor::TSenderCallback callback)
{
    auto filler = std::make_shared<NDetail::TFiller>(ctx, provider, newRecipients, std::move(callback));
    yplatform::spawn(filler);
}

}
