#pragma once

#include "handler.h"
#include <mail/notsolitesrv/src/errors.h>

namespace NNotSoLiteSrv::NHttp {

class TStore: public IHandler {
public:
    std::string Name() const override { return "store"; }
    std::vector<std::string> Paths() const override { return { "/store" }; }
    std::vector<EMethod> AllowedMethods() const override { return { EMethod::mth_post }; }
    void Execute(TContextPtr ctx, THttpStreamPtr stream, TCallback callback) override;

private:
    void OnComplete(THttpStreamPtr stream, TErrorCode errc, std::string response, TCallback callback);
    void OnError(TContextPtr ctx, THttpStreamPtr stream, TErrorCode errc, std::string reason,
        TCallback callback);
};

} // namespace NNotSoLiteSrv::NHttp
