#pragma once

#include "common.h"

#include <cstdint>
#include <map>
#include <optional>
#include <string>
#include <vector>

namespace NNotSoLiteSrv::NHttp {

struct TMailFrom {
    std::string Email;
};

struct TEnvelope {
    std::string RemoteIp;
    std::string RemoteHost;
    TMailFrom MailFrom;
    std::string EnvelopeId;
    std::string Helo;
};

using THint = std::map<std::string, std::vector<std::string>>;
using THints = std::vector<THint>;

struct TMessage {
    std::string Stid;
    int64_t Timemark;
    THints Hints;
};

struct TStoreRequestRecipient {
    std::string Email;
    std::optional<std::string> Uid;
    std::string IsLocal;
    TNotification Notify;
    std::optional<bool> IsMailish;
};

using TStoreRequestRecipients = std::vector<TStoreRequestRecipient>;

struct TStoreRequest {
    TEnvelope Envelope;
    TMessage Message;
    TStoreRequestRecipients Recipients;
};

}
