#pragma once

#include "common.h"

#include <optional>
#include <string>
#include <vector>

namespace NNotSoLiteSrv::NHttp {

struct TDeliveryResult {
    std::optional<std::string> Mid;
    std::optional<std::string> ImapId;
    std::optional<std::string> Stid;
};

struct TStoreResponseRecipient {
    std::string Email;
    std::optional<std::string> Uid;
    std::string IsLocal;
    TNotification Notify;
    std::optional<TDeliveryResult> DeliveryResult;
    std::string Status;
};

using TStoreResponseRecipients = std::vector<TStoreResponseRecipient>;

struct TStoreResponse {
    TStoreResponseRecipients Recipients;
};

}
