#include "util.h"

#include <butil/http/headers.h>

namespace NNotSoLiteSrv {

std::string MakeHttpStatusMessage(THttpResponse response) {
    return "status=" + std::to_string(response.status) + ", reason=" + std::move(response.reason) +
        ", body=" + std::move(response.body);
}

std::string MakeTvmServiceTicketHeader(const std::string& tvmServiceTicket) {
    http::headers headers;
    headers.add("X-Ya-Service-Ticket", tvmServiceTicket);
    return headers.format();
}

}
