#pragma once

#include "iclient.h"

#include <mail/notsolitesrv/src/context.h>
#include <mail/notsolitesrv/src/http/types.h>
#include <mail/notsolitesrv/src/types/common.h>

namespace NNotSoLiteSrv::NMdbSave {

class TMdbSaveClient : public IMdbSaveClient {
public:
    TMdbSaveClient(TContextPtr ctx, TClusterCallPtr clusterCall, TTvmModulePtr tvmModule);

    void MdbSave(boost::asio::io_context& ioContext, std::string sessionId,
        TMdbSaveRequest mdbsaveRequest, TMdbSaveCallback callback) const override;

private:
    using TErrorResult = std::optional<TErrorResponse>;

    THttpRequest MakeMdbSaveRequest(std::string sessionId, const TMdbSaveRequest& MdbSaveRequest) const;
    std::string GetTvmServiceTicket() const;
    void ProcessMdbSaveResponse(TErrorCode errorCode, THttpResponse response, TMdbSaveCallback callback) const;
    TMdbSaveResult ParseMdbSaveResponse(std::string responseBody) const;
    void ProcessError(TErrorCode errorCode, THttpResponse response, TMdbSaveCallback callback) const;
    std::string MakeErrorStatusMessage(std::string responseBody) const;
    TErrorResult ParseErrorResponse(std::string responseBody) const;

    const TContextPtr Ctx;
    const TClusterCallPtr ClusterCall;
    const TTvmModulePtr TvmModule;
};

}
