#pragma once

#include <mail/notsolitesrv/src/errors.h>
#include <mail/notsolitesrv/src/mdbsave/types/request.h>
#include <mail/notsolitesrv/src/mdbsave/types/response.h>

#include <boost/asio.hpp>

#include <functional>
#include <memory>
#include <optional>
#include <string>

namespace NNotSoLiteSrv::NMdbSave {

using TMdbSaveResult = std::optional<TMdbSaveResponse>;
using TMdbSaveCallback = std::function<void(TErrorCode, TMdbSaveResult)>;

class IMdbSaveClient {
public:
    virtual ~IMdbSaveClient() = default;

    virtual void MdbSave(boost::asio::io_context& ioContext, std::string sessionId,
        TMdbSaveRequest mdbsaveRequest, TMdbSaveCallback callback) const = 0;
};

using TMdbSaveClientPtr = std::shared_ptr<IMdbSaveClient>;

}
