#pragma once

#include <mail/notsolitesrv/src/mdbsave/types/attachment.h>
#include <mail/notsolitesrv/src/mdbsave/types/header.h>
#include <mail/notsolitesrv/src/mdbsave/types/label.h>
#include <mail/notsolitesrv/src/mdbsave/types/mime_part.h>
#include <mail/notsolitesrv/src/mdbsave/types/storage.h>
#include <mail/notsolitesrv/src/mdbsave/types/thread_info.h>

#include <optional>
#include <string>

namespace NNotSoLiteSrv::NMdbSave {

using TRequestLids = std::vector<std::string>;
using TRequestLabelSymbols = std::vector<std::string>;
using TRequestLabels = std::vector<TRequestLabel>;

struct TMessage {
    std::optional<std::string> OldMid;
    std::optional<std::int64_t> ExtImapId;
    std::string Firstline;
    std::optional<std::size_t> Size;
    std::optional<TRequestLids> Lids;
    std::optional<TRequestLabelSymbols> LabelSymbols;
    std::optional<TRequestLabels> Labels;
    std::optional<std::string> Tab;
    TStorage Storage;
    THeaders Headers;
    std::optional<std::vector<TAttachment>> Attachments;
    std::optional<std::vector<TMimePart>> MimeParts;
    TThreadInfo ThreadInfo;
};

}
