#pragma once

#include <mail/notsolitesrv/src/mdbsave/types/actions.h>
#include <mail/notsolitesrv/src/mdbsave/types/folders.h>
#include <mail/notsolitesrv/src/mdbsave/types/message.h>
#include <mail/notsolitesrv/src/mdbsave/types/user.h>

#include <optional>
#include <string>

namespace NNotSoLiteSrv::NMdbSave {

using TRequestAddedLids = std::vector<std::string>;
using TRequestAddedSymbols = std::vector<std::string>;

struct TMdbSaveRequestRcpt {
    TUser User;
    TMessage Message;
    TRequestFolders Folders;
    TActions Actions;
    std::optional<TRequestAddedLids> AddedLids;
    std::optional<TRequestAddedSymbols> AddedSymbols;
    bool Imap;
};

struct TMdbSaveRequestRcptNode {
    std::string Id;
    TMdbSaveRequestRcpt Rcpt;
};

struct TMdbSaveRequest {
    std::vector<TMdbSaveRequestRcptNode> Rcpts;
    bool Sync;
};

}
