#pragma once

#include <mail/notsolitesrv/src/mdbsave/types/folders.h>
#include <mail/notsolitesrv/src/mdbsave/types/label.h>

#include <optional>
#include <string>
#include <vector>

namespace NNotSoLiteSrv::NMdbSave {

struct TMdbSaveResponseRcpt {
    std::string Uid;
    std::string Status; // ok, perm error, temp error
    std::optional<std::string> Description;
    std::optional<std::string> Mid;
    std::optional<std::string> ImapId;
    std::optional<std::string> Tid;
    std::optional<bool> Duplicate;
    std::optional<TResolvedFolder> Folder;
    std::optional<std::vector<TResponseLabel>> Labels;
};

struct TMdbSaveResponseRcptNode {
    std::string Id;
    TMdbSaveResponseRcpt Rcpt;
};

struct TMdbSaveResponse {
    std::vector<TMdbSaveResponseRcptNode> Rcpts;
};

struct TErrorResponse {
    std::string Error;
    std::string Message;
};

}
