#include "parser.h"
#include "parser/header_handler_factory.h"
#include "parser/message_handler.h"

#include <mimeparser/MessageParser.h>

namespace NNotSoLiteSrv {

constexpr int MAX_INLINE_LEVEL = 30;
TPartPtr ParsePart(
    const TStringBuf& messageData,
    TPartPtr parent,
    int inlineLevel)
{
    using TIterator = std::string::const_iterator;
    using THandler = TMessageHandler<TIterator>;
    using THHFactory = THeaderHandlerFactory<TIterator>;
    using TParser = MimeParser::Parsers::MessageParser<TIterator, THandler, THHFactory>;

    if (inlineLevel > MAX_INLINE_LEVEL) {
        return TPartPtr();
    }

    THandler messageHandler(messageData, parent, ++inlineLevel);
    THHFactory factory;
    TParser parser(messageData.begin() + (parent ? parent->GetOffset() : 0), messageHandler, factory);
    parser.push(parent ? messageData.begin() + parent->GetOffset() + parent->GetLength() + 1 : messageData.end());
    parser.stop();

    return messageHandler.result();
}

TMessagePtr ParseMessage(const std::string& messageData, TContextPtr ctx, bool isHttpSession) {
    if (messageData.empty()) {
        throw std::runtime_error("empty message");
    }

    auto rootPart = ParsePart(messageData, TPartPtr(), 0);
    if (!rootPart) {
        throw std::runtime_error("cannot parse message");
    }

    if (rootPart->GetLength() == 0 && rootPart->GetHeaders().empty()) {
        throw std::runtime_error("cannot parse message");
    }

    return TMessage::CreateMessageFromRootPart(std::move(*rootPart), ctx, isHttpSession);
}

} // namespace NNotSoLiteSrv
