#include "header_data.h"
#include <mail/notsolitesrv/src/util/headers.h>
#include <mail/library/utf8/utf8.h>
#include <boost/algorithm/string/predicate.hpp>

namespace NNotSoLiteSrv {

const rfc2822::old_rfc2822address* THeaderData::from() const {
    if (From) {
        return From.get();
    }
    return nullptr;
}

const rfc2822::old_rfc2822address* THeaderData::to() const {
    if (To) {
        return To.get();
    }
    return nullptr;
}

const rfc2822::old_rfc2822address* THeaderData::cc() const {
    if (Cc) {
        return Cc.get();
    }
    return nullptr;
}

bool THeaderData::parseFrom(const MimeParser::HeaderField& headerField) {
    From = std::make_unique<rfc2822::old_rfc2822address>(headerField.value());
    return true;
}

bool THeaderData::parseTo(const MimeParser::HeaderField& headerField) {
    To = std::make_unique<rfc2822::old_rfc2822address>(headerField.value());
    return true;
}

bool THeaderData::parseCc(const MimeParser::HeaderField& headerField) {
    Cc = std::make_unique<rfc2822::old_rfc2822address>(headerField.value());
    return true;
}

bool THeaderData::parseContentType(const MimeParser::HeaderField& headerField) {
    // special hack for brain-damaged MAILDLV-2505
    auto value = ::NUtil::Utf8Trim(::NUtil::Utf8Sanitized(headerField.value()));
    if (boost::starts_with(value, "=?") && boost::ends_with(value, "?=")) {
        std::string fakeHeader = headerField.name() + ": " + NUtil::DecodeHeaderRfc2047(value);
        return HeaderData.parseContentType(MimeParser::HeaderField(fakeHeader));
    }
    return HeaderData.parseContentType(headerField);
}

} // namespace NNotSoLiteSrv
