#pragma once

#include <mimeparser/HeaderData.h>
#include <mimeparser/HeaderField.h>
#include <mimeparser/rfc2822address.h>

#include <string>
#include <vector>

namespace NNotSoLiteSrv {

class THeaderData {
public:
    using HeaderFields = std::vector<MimeParser::HeaderField>;
    explicit THeaderData(bool unfolded): HeaderData(unfolded) {}

    const std::string& cType() const { return HeaderData.cType(); }
    const std::string& contentSubtype() const { return HeaderData.contentSubtype(); }
    const std::string& boundary() const { return HeaderData.boundary(); }
    const std::string& charset() const { return HeaderData.charset(); }
    const mulca_mime::DecodedString& name() const { return HeaderData.name(); }
    const std::string& content_transfer_encoding() const { return HeaderData.content_transfer_encoding(); }
    const std::string& content_disposition() const { return HeaderData.content_disposition(); }
    const mulca_mime::DecodedString& filename() const { return HeaderData.filename(); }
    const std::string& content_id() const { return HeaderData.content_id(); }

    const rfc2822::old_rfc2822address* from() const;
    const rfc2822::old_rfc2822address* to() const;
    const rfc2822::old_rfc2822address* cc() const;

    const std::string& messageId() const { return HeaderData.messageId(); }
    const HeaderFields& headerFields() const { return HeaderData.headerFields(); }
    bool isInlineMessage() const { return HeaderData.isInlineMessage(); }

public:
    bool parseContentDisposition(const MimeParser::HeaderField& headerField) { return HeaderData.parseContentDisposition(headerField); }
    bool parseContentTransferEncoding(const MimeParser::HeaderField& headerField) { return HeaderData.parseContentTransferEncoding(headerField); }
    bool parseContentId(const MimeParser::HeaderField& headerField) { return HeaderData.parseContentId(headerField); }
    bool parseMessageId(const MimeParser::HeaderField& headerField) { return HeaderData.parseMessageId(headerField); }
    bool addHeaderField(const MimeParser::HeaderField& headerField) { return HeaderData.addHeaderField(headerField); }
    bool parseFrom(const MimeParser::HeaderField& headerField);
    bool parseTo(const MimeParser::HeaderField& headerField);
    bool parseCc(const MimeParser::HeaderField& headerField);
    bool parseContentType(const MimeParser::HeaderField& headerField);

private:
    // down there are old-related mimeparser structures
    std::unique_ptr<rfc2822::old_rfc2822address> From;
    std::unique_ptr<rfc2822::old_rfc2822address> To;
    std::unique_ptr<rfc2822::old_rfc2822address> Cc;

    MimeParser::HeaderData HeaderData;
};

} // namespace NNotSoLiteSrv
