#pragma once

#include "header_data.h"
#include <mimeparser/HeaderHandler.h>

namespace NNotSoLiteSrv {

template <typename TIterator>
class THeaderHandlerFactory {
public:
    using Handler = MimeParser::Handlers::HeaderHandler<TIterator, THeaderData>;
public:
    std::unique_ptr<Handler> create() const {
        return std::make_unique<Handler>(Handler::PARSE_FULL_MODE, false);
    }
    void setParseInline(bool doParseInline) {
        ParseInline = doParseInline;
    }
    bool doParseInline() const {
        return ParseInline;
    }
    void setCalculateRealLength(bool doCalculateRealLength) {
        CalculateRealLength = doCalculateRealLength;
    }
    bool doCalculateRealLength() const {
        return CalculateRealLength;
    }
private:
    bool ParseInline = false;
    bool CalculateRealLength = false;
};

} // namespace NNotSoLiteSrv
