#pragma once

#include "header_data.h"
#include <mail/notsolitesrv/src/message/part.h>
#include <mimeparser/HeaderHandler.h>
#include <stack>

namespace NNotSoLiteSrv {

template <typename TIterator, typename THHandler = MimeParser::Handlers::HeaderHandler<TIterator, THeaderData>>
class TMessageHandler {
public:
    using TRange = boost::iterator_range<TIterator>;
    TMessageHandler(const TStringBuf& messageData, TPartPtr parent, int inlineLevel)
        : Message(TPart::CreateShared(messageData, parent))
        , MessageData(messageData)
        , InlineLevel(inlineLevel)
        , Parent(parent)
    {}

    bool beginMessage(const TIterator& pos);
    bool endMessage(const TIterator&) const { return true; }

    bool beginPart(const TIterator& pos, const THHandler& hHandler);
    bool endPart(const TIterator& pos);

    bool beginHeader(const TIterator&) const { return true; }
    bool endHeader(const TIterator&) const { return true; }

    bool handleBodyLine(const TRange&) const { return true; }

    void addError(const std::string&) const { /* ignore errors */ }

    TPartPtr result() const { return Message; }

private:
    size_t CalcOffset(const TIterator& pos) const;
    size_t CalcLength(const TIterator& pos) const;
    void CreatePart(const TIterator& pos);

    TPartPtr Message;
    TStringBuf MessageData;
    int InlineLevel = 0;

    std::stack<TPartPtr> PartsStack;
    TPartPtr CurrentPart;
    TPartPtr Parent;

    TIterator Start;
};

namespace NDetail {

std::string HandleContentId(const std::string& str);
std::string HandleDecodedString(const mulca_mime::DecodedString& dstr);
bool HandlePossiblyIncorrectRfc2231Value(const std::string& value, std::string& out);

} // namespace NDetail

} // namespace NNotSoLiteSrv
