#include "part.h"

namespace NNotSoLiteSrv {

TPart::TConstIterator& TPart::TConstIterator::operator++() {
    if (!Node->Children.empty()) {
        NodeStack.emplace_back(Node, Node->Children.begin());
        Node = Node->Children.begin()->get();
        return *this;
    }

    while (!NodeStack.empty()) {
        auto& stackElem = NodeStack.back();

        if (++stackElem.second != stackElem.first->Children.end()) {
            Node = stackElem.second->get();
            break;
        } else {
            Node = nullptr;
            NodeStack.pop_back();
        }
    }

    if (NodeStack.empty()) {
        Node = nullptr;
    }

    return *this;
}

TPartPtr TPart::CreateShared(const TStringBuf& messageData, TPartPtr parent) {
    TPart* part = new TPart(messageData, parent);
    try {
        return TPartPtr(part);
    } catch (...) {
        delete part;
        throw;
    }
}

TPart::TConstIterator TPart::begin() const {
    return TConstIterator(this);
}

TPart::TConstIterator TPart::end() const {
    return TConstIterator();
}

} // namespace NNotSoLiteSrv
