#include "types.h"
#include <mail/message_types/lib/message_types.h>
#include <util/string/cast.h>
#include <string>

namespace NNotSoLiteSrv {

std::string ConvertSoLabelToType(const std::string& label) {
    try {
        return std::to_string(FromString<NMail::EMessageType>(label));
    } catch (const std::exception&) {
        return "";
    }
}

std::string ToString(ESpamResolutionType resolutionType) {
    switch (resolutionType) {
        case ESpamResolutionType::Global:
            return "Global";
        case ESpamResolutionType::PersonalByUid:
            return "Personal by UID";
    }

    return "Unknown";
}

} // namespace NNotSoLiteSrv
