#pragma once

#include <boost/optional.hpp>
#include <string>
#include <vector>

namespace NNotSoLiteSrv {

struct TXYandexHint {
    std::string ToString() const;

    std::string service;
    time_t hdr_date = 0;
    time_t received_date = 0;
    std::string folder;
    std::string folder_path;
    std::string folder_spam_path;
    std::string folder_path_delim{"/"};
    std::string fid;
    int64_t mixed = 0;
    bool skip_loop_prevention = false;
    std::vector<std::string> skip_loop_prevention_for_suid;
    std::string ipfrom;     // for wmi
    std::string method_id;  // for wmi
    std::string session_key;// for wmi
    bool notify = true;
    bool forward = true;
    bool filters = true;
    bool imap = false;
    std::vector<std::string> label;
    std::vector<std::string> imaplabel;
    std::vector<std::string> userlabel;
    std::vector<std::string> lid;
    std::vector<std::string> bcc;
    std::string source_stid;
    std::string mid;
    std::string email;
    bool copy_to_inbox = false;
    boost::optional<bool> save_to_sent;
    boost::optional<ssize_t> final_headers_len;
    std::string body_md5;
    boost::optional<bool> meta_blob;
    uint64_t external_imap_id = 0;
    bool allow_autoreply = false;
    bool disable_push = false;
    bool priority_high = false;
    std::string phone;
    std::string session_id;
    bool store_as_deleted = false;
    bool skip_meta_msg = false;
    bool sync_dlv = false;
    bool no_such_fid_fail = false;
    bool replace_so_labels = false;
};

} // namespace NNotSoLiteSrv
