#pragma once

#include <mail/notsolitesrv/src/errors.h>
#include <mail/notsolitesrv/src/firstline/ifirstline.h>
#include <mail/notsolitesrv/src/furita/iclient.h>
#include <mail/notsolitesrv/src/mdbsave/iclient.h>
#include <mail/notsolitesrv/src/meta_save_op/types/request.h>
#include <mail/notsolitesrv/src/tupita/iclient.h>
#include <mail/yplatform/include/yplatform/coroutine.h>

#include <functional>
#include <memory>
#include <variant>

namespace NNotSoLiteSrv::NMetaSaveOp {

using TMetaSaveOpCallback = std::function<void(TErrorCode)>;

class IMetaSaveOp {
public:
    virtual ~IMetaSaveOp() = default;

    virtual void SetOpParams(TRequest request, TMetaSaveOpCallback callback) = 0;

    using TYieldCtx = yplatform::yield_context<IMetaSaveOp>;
    using TResult = std::variant<
        NFirstline::TFirstlineResult,
        NFurita::TListResult,
        NMdbSave::TMdbSaveResult,
        NTupita::TCheckResult>;
    virtual void operator()(TYieldCtx yieldCtx, TErrorCode errorCode = {}, TResult result = {}) = 0;
};

using TMetaSaveOpPtr = std::shared_ptr<IMetaSaveOp>;

}
