#pragma once

#include "imeta_save_op.h"

#include <mail/notsolitesrv/src/context.h>
#include <mail/notsolitesrv/src/firstline/firstline.h>
#include <mail/notsolitesrv/src/http/types.h>
#include <mail/notsolitesrv/src/mthr/imthr.h>
#include <mail/notsolitesrv/src/rules_applier/types/response.h>
#include <mail/notsolitesrv/src/types/common.h>
#include <mail/notsolitesrv/src/user/storage.h>

#include <boost/asio.hpp>

#include <map>
#include <optional>
#include <set>
#include <variant>

namespace NNotSoLiteSrv::NMetaSaveOp {

struct TMetaSaveOpClients {
    NFurita::TFuritaClientPtr Furita;
    NMdbSave::TMdbSaveClientPtr MdbSave;
    NTupita::TTupitaClientPtr Tupita;
};

struct TMetaSaveOpComponents {
    NFirstline::TFirstlinePtr Firstline;
    NMthr::TMthrPtr Mthr;
};

struct TMetaSaveOpParams {
    TRequest Request;
    TMetaSaveOpCallback Callback;
};

struct TFirstlineComponentResult {
    TErrorCode ErrorCode;
    NFirstline::TFirstlineResult Result;
};

struct TFuritaClientResult {
    TErrorCode ErrorCode;
    NFurita::TListResult Result;
};

using TFuritaClientResults = std::map<TUid, TFuritaClientResult>;

struct TMdbSaveClientResult {
    TErrorCode ErrorCode;
    NMdbSave::TMdbSaveResult Result;
};

struct TTupitaClientResult {
    TErrorCode ErrorCode;
    NTupita::TCheckResult Result;
};

using TTupitaClientResults = std::map<TUid, TTupitaClientResult>;

struct TMetaSaveOpClientResults {
    TFuritaClientResults Furita;
    TMdbSaveClientResult MdbSave;
    TTupitaClientResults Tupita;
};

using TRulesApplierResult = std::optional<NRulesApplier::TRulesApplierResponse>;
struct TRulesApplierComponentResult {
    TRulesApplierResult Result;
};

struct TMthrComponentResult {
    TErrorCode ErrorCode;
    NMthr::TMthrResult Result;
};

struct TMetaSaveOpComponentResults {
    TRulesApplierComponentResult RulesApplier;
    TFirstlineComponentResult Firstline;
    TMthrComponentResult Mthr;
};

class TMetaSaveOp : public IMetaSaveOp {
public:
    TMetaSaveOp(TMetaSaveOpClients clients, TMetaSaveOpComponents components, TContextPtr ctx,
        NUser::TStoragePtr userStorage, boost::asio::io_context& ioContext);

    void SetOpParams(TRequest request, TMetaSaveOpCallback callback) override;
    void operator()(TYieldCtx yieldCtx, TErrorCode errorCode = {}, TResult result = {}) override;

private:
    void RequestFirstline(const TYieldCtx& yieldCtx);
    void RequestFurita(const TYieldCtx& yieldCtx);
    void RequestTupita(const TYieldCtx& yieldCtx);
    void RequestMdbSave(const TYieldCtx& yieldCtx);

    bool ProcessFirstlineResult(TErrorCode errorCode, TResult result);
    void ProcessFuritaListResult(TErrorCode errorCode, TResult result);
    void ProcessTupitaCheckResult(TErrorCode errorCode, TResult result);
    bool ProcessMdbSaveResult(TErrorCode errorCode, TResult result);

    NMthr::TMthrResult RequestMthr() const;
    bool ProcessMthrResult(NMthr::TMthrResult result);

    void ProcessResponses() const;
    bool FatalErrorPresent() const;
    bool FatalClientErrorPresent() const;
    bool FatalComponentErrorPresent() const;
    void SetUsersError(const TErrorCode& errorCode) const;

    template<typename TSpecificResult> bool CheckSpecificResult(const TResult& result) const {
        return std::holds_alternative<TSpecificResult>(result) && std::get<TSpecificResult>(result);
    }

    const TMetaSaveOpClients Clients;
    const TMetaSaveOpComponents Components;
    const TContextPtr Ctx;
    const NUser::TStoragePtr UserStorage;
    boost::asio::io_context& IoContext;
    TMetaSaveOpParams Params;
    std::set<TUid> FuritaUids;
    TUid Uid{0};
    TMetaSaveOpClientResults ClientResults;
    TMetaSaveOpComponentResults ComponentResults;
};

}
