#pragma once

#include <mail/notsolitesrv/src/user/storage.h>
#include <mail/notsolitesrv/src/context.h>
#include <boost/optional.hpp>
#include <map>
#include <string>
#include <vector>

namespace NNotSoLiteSrv::NMetaSaveOp {

enum class EStatus {
    Ok,
    TemporaryError,
    PermanentError,
    Unknown
};

struct TResolvedLabel {
    std::string lid;
    boost::optional<std::string> symbol;
};

struct TResolvedFolder {
    std::string fid;
    boost::optional<std::string> name;
    boost::optional<std::string> type;
    boost::optional<uint32_t> type_code;
};

struct TMdbCommitResponse {
    std::string uid;
    EStatus status = EStatus::Unknown;
    boost::optional<std::string> description;
    boost::optional<std::string> mid;
    boost::optional<uint32_t> imap_id = 0;
    boost::optional<bool> duplicate = false;
    boost::optional<std::string> tid;
    boost::optional<TResolvedFolder> folder;
    boost::optional<std::vector<TResolvedLabel>> labels;
};

struct TAutoReply {
    std::string address;
    std::string body;
};

struct TForward {
    std::string address;
};

struct TNotify {
    std::string address;
};

struct TRecipientResponse {
    EStatus status;
    boost::optional<std::vector<TAutoReply>> reply;
    boost::optional<std::vector<TForward>> forward;
    boost::optional<std::vector<TNotify>> notify;
    boost::optional<std::vector<std::string>> rule_ids;
    boost::optional<TMdbCommitResponse> mdb_commit;
};

struct TResponse {
    using TMdbResponses = std::map<std::string, TRecipientResponse>;
    TMdbResponses mdb_responses;
};

void UpdateRecipientsStatusFromResponse(TContextPtr ctx, NUser::TStorage& userStorage,
    const TResponse& response) noexcept;

}
