#include "common.h"

#include <algorithm>

namespace NNotSoLiteSrv::NMetaSaveOp {

bool FiltersInUse(const TRecipientMap& recipients) {
    return std::any_of(recipients.cbegin(), recipients.cend(),
        [](const auto& element){return element.second.params.use_filters;});
}

std::string ToString(const TEmailAddress& emailAddress) {
    if (emailAddress.Local.empty() || emailAddress.Domain.empty()) {
        return {};
    }

    return emailAddress.Local + "@" + emailAddress.Domain;
}

std::optional<std::reference_wrapper<const TRecipient>> FindRecipientByUid(const TRecipientMap& recipients,
    TUid uid)
{
    auto predicate = [&](const auto& element){return element.second.user.uid == uid;};
    const auto element = std::find_if(recipients.cbegin(), recipients.cend(), std::move(predicate));
    if (element == recipients.end()) {
        return {};
    } else {
        return std::cref(element->second);
    }
}

}
