#pragma once

#include <mail/notsolitesrv/src/meta_save_op/types/request.h>
#include <mail/notsolitesrv/src/types/common.h>
#include <mail/notsolitesrv/src/types/email_address.h>

#include <cstdint>
#include <functional>
#include <optional>
#include <string>
#include <vector>

namespace NNotSoLiteSrv::NMetaSaveOp {

bool FiltersInUse(const TRecipientMap& recipients);
std::string ToString(const TEmailAddress& emailAddress);

std::optional<std::reference_wrapper<const TRecipient>> FindRecipientByUid(const TRecipientMap& recipients,
    TUid uid);

template<typename Range> std::optional<Range> MakeOptionalRange(const Range& range) {
    return (!range.empty()) ? std::make_optional(range) : std::nullopt;
}

}
