#include "firstline.h"

#include <mail/message_types/lib/message_types.h>

#include <boost/range/adaptor/filtered.hpp>

#include <algorithm>

namespace NNotSoLiteSrv::NMetaSaveOp {

std::pair<bool, std::string> FindPartForFirstline(const TPartMap& parts) {
    auto filter =
        [](const auto& element){return (element.second.content_type == "text") && element.second.data;};
    const auto html = true;
    std::string plainPart;
    for (const auto& element : parts | boost::adaptors::filtered(std::move(filter))) {
        const auto& part = element.second;
        if (part.content_subtype == "html") {
            return {html, *part.data};
        }

        if (plainPart.empty() && part.content_subtype == "plain") {
            plainPart = *part.data;
        }
    }

    return {!html, std::move(plainPart)};
}

bool PeopleTypePresent(const std::vector<uint32_t>& types) {
    return std::any_of(types.cbegin(), types.cend(), [](const auto& type){return type == NMail::MT_PEOPLE;});
}

NFirstline::TFirstlineRequest MakeFirstlineRequest(const TRequest& request) {
    NFirstline::TFirstlineRequest firstlineRequest;
    std::tie(firstlineRequest.IsHtml, firstlineRequest.Part) = FindPartForFirstline(request.message.parts);
    firstlineRequest.Subject = request.message.subject;
    if (!request.message.from.empty()) {
        firstlineRequest.From = request.message.from.front();
    }

    firstlineRequest.IsPeopleType = PeopleTypePresent(request.types);

    return firstlineRequest;
}

}
