#include "furita.h"

#include <boost/range/adaptor/filtered.hpp>

#include <algorithm>

namespace NNotSoLiteSrv::NMetaSaveOp {

std::set<TUid> MakeFuritaUids(const TRecipientMap& recipients) {
    std::set<TUid> uids;
    auto filter = [](const auto& element){return element.second.params.use_filters;};
    for (const auto& element : recipients | boost::adaptors::filtered(std::move(filter))) {
        uids.emplace(element.second.user.uid);
    }

    return uids;
}

bool HasVerifiedAction(const NFurita::TFuritaRule& rule) {
    auto predicate = [](const auto& action){return action.Verified;};
    return std::any_of(rule.Actions.cbegin(), rule.Actions.cend(), std::move(predicate));
}

bool EnabledRuleWithVerifiedAction(const NFurita::TFuritaRule& rule) {
    return rule.Enabled && HasVerifiedAction(rule);
}

bool EnabledRuleWithVerifiedActionAvailable(const std::vector<NFurita::TFuritaRule>& rules) {
    auto predicate{[](const auto& rule){return EnabledRuleWithVerifiedAction(rule);}};
    return std::any_of(rules.cbegin(), rules.cend(), std::move(predicate));
}

TFuritaRuleByPriorityAndIdMap MakeFuritaRuleByPriorityAndIdMap(const std::vector<NFurita::TFuritaRule>& rules)
{
    TFuritaRuleByPriorityAndIdMap furitaRuleByPriorityAndId;
    auto filter{[](const auto& rule){return EnabledRuleWithVerifiedAction(rule);}};
    for (const auto& rule : rules | boost::adaptors::filtered(std::move(filter))) {
        furitaRuleByPriorityAndId.emplace(std::make_pair(rule.Priority, rule.Id), rule);
    }

    return furitaRuleByPriorityAndId;
}

}
