#pragma once

#include <mail/notsolitesrv/src/furita/types/response.h>
#include <mail/notsolitesrv/src/meta_save_op/types/request.h>
#include <mail/notsolitesrv/src/types/common.h>

#include <cstdint>
#include <map>
#include <set>
#include <string>
#include <utility>
#include <vector>

namespace NNotSoLiteSrv::NMetaSaveOp {

std::set<TUid> MakeFuritaUids(const TRecipientMap& recipients);
bool HasVerifiedAction(const NFurita::TFuritaRule& rule);
bool EnabledRuleWithVerifiedAction(const NFurita::TFuritaRule& rule);
bool EnabledRuleWithVerifiedActionAvailable(const std::vector<NFurita::TFuritaRule>& rules);

using TFuritaRuleByPriorityAndIdMap = std::map<std::pair<int64_t, std::string>, NFurita::TFuritaRule>;
TFuritaRuleByPriorityAndIdMap MakeFuritaRuleByPriorityAndIdMap(
    const std::vector<NFurita::TFuritaRule>& rules);

}
