#pragma once

#include <mail/notsolitesrv/src/firstline/ifirstline.h>
#include <mail/notsolitesrv/src/mdbsave/types/request.h>
#include <mail/notsolitesrv/src/mdbsave/types/response.h>
#include <mail/notsolitesrv/src/meta_save_op/types/request.h>
#include <mail/notsolitesrv/src/mthr/types/response.h>
#include <mail/notsolitesrv/src/rules_applier/types/response.h>
#include <mail/notsolitesrv/src/types/common.h>

#include <functional>
#include <optional>
#include <string>
#include <vector>

namespace NNotSoLiteSrv::NMetaSaveOp {

bool RecipientSucceeded(const TDeliveryId& deliveryId,
    const std::optional<NRulesApplier::TRulesApplierResponse>& rulesApplierResponse);

bool RecipientToSaveForAvailable(const TRecipientMap& recipients,
    const std::optional<NRulesApplier::TRulesApplierResponse>& rulesApplierResponse);

NMdbSave::TUser MakeMdbSaveUser(const TUser& user);
NMdbSave::TRequestLabel MakeMdbSaveRequestLabel(const TLabel& label);
std::optional<NMdbSave::TRequestLabels> MakeMdbSaveRequestLabels(const std::vector<TLabel>& labels);
NMdbSave::TStorage MakeMdbSaveStorage(const TDeliveryId& deliveryId, const TRequest& request);
NMdbSave::THeaders MakeMdbSaveHeaders(const TDeliveryId& deliveryId, const TRequest& request);
NMdbSave::TAttachment MakeMdbSaveAttachment(const std::string& hid, const TAttachment& attachment);

std::optional<std::vector<NMdbSave::TAttachment>> MakeMdbSaveAttachments(
    const NMetaSaveOp::TMessage& message);

NMdbSave::TMimePart MakeMdbSaveMimePart(const std::string& hid, const NMetaSaveOp::TPart& part);
std::optional<std::vector<NMdbSave::TMimePart>> MakeMdbSaveMimeParts(const TPartMap& parts);
NMdbSave::TThreadInfo MakeMdbSaveThreadInfo(const NMthr::TThreadInfo& threadInfo);

NMdbSave::TMessage MakeMdbSaveMessage(const TDeliveryId& deliveryId, const TRequest& request,
    const NFirstline::TFirstlineResult& firstline, const NMthr::TMthrResponse& mthr);

std::optional<NMdbSave::TRequestFolder> MakeMdbSaveRequestDestinationFolder(const TDeliveryId& deliveryId,
    const std::optional<NRulesApplier::TRulesApplierResponse>& rulesApplierResponse);

std::optional<NMdbSave::TRequestFolder> MakeMdbSaveRequestOriginalFolder(const TParams& params);

NMdbSave::TRequestFolders MakeMdbSaveRequestFolders(const TDeliveryId& deliveryId, const TRequest& request,
    const std::optional<NRulesApplier::TRulesApplierResponse>& rulesApplierResponse);

NMdbSave::TDuplicates MakeMdbSaveActionDuplicates(const TParams& params);
NMdbSave::TFolderActions MakeMdbSaveOriginalFolderActions(const TParams& params);

std::optional<NMdbSave::TFolderActions> MakeMdbSaveRulesApplierFolderActions(const TDeliveryId& deliveryId,
    const std::optional<NRulesApplier::TRulesApplierResponse>& rulesApplierResponse);

NMdbSave::TActions MakeMdbSaveActions(const TDeliveryId& deliveryId, const TRequest& request,
    const std::optional<NRulesApplier::TRulesApplierResponse>& rulesApplierResponse);

std::optional<NMdbSave::TRequestAddedLids> MakeMdbSaveAddedLids(const TDeliveryId& deliveryId,
    const std::optional<NRulesApplier::TRulesApplierResponse>& rulesApplierResponse);

std::optional<NMdbSave::TRequestAddedSymbols> MakeMdbSaveAddedSymbols(const TDeliveryId& deliveryId,
    const std::optional<NRulesApplier::TRulesApplierResponse>& rulesApplierResponse);

NMdbSave::TMdbSaveRequestRcpt MakeMdbSaveRcpt(
    const TDeliveryId& deliveryId,
    const TRequest& request,
    const NFirstline::TFirstlineResult& firstline,
    const NMthr::TMthrResponse& mthr,
    const std::optional<NRulesApplier::TRulesApplierResponse>& rulesApplierResponse);

NMdbSave::TMdbSaveRequestRcptNode MakeMdbSaveRcptNode(
    const TDeliveryId& deliveryId,
    const TRequest& request,
    const NFirstline::TFirstlineResult& firstline,
    const NMthr::TMthrResponse& mthr,
    const std::optional<NRulesApplier::TRulesApplierResponse>& rulesApplierResponse);

std::vector<NMdbSave::TMdbSaveRequestRcptNode> MakeMdbSaveRcpts(
    const TRequest& request,
    const NFirstline::TFirstlineResult& firstline,
    const NMthr::TMthrResponse& mthr,
    const std::optional<NRulesApplier::TRulesApplierResponse>& rulesApplierResponse);

NMdbSave::TMdbSaveRequest MakeMdbSaveRequest(
    const TRequest& request,
    const NFirstline::TFirstlineResult& firstline,
    const NMthr::TMthrResponse& mthr,
    const std::optional<NRulesApplier::TRulesApplierResponse>& rulesApplierResponse);

std::optional<std::reference_wrapper<const NMdbSave::TMdbSaveResponseRcpt>>
    FindMdbSaveResponseRcptByDeliveryId(const TDeliveryId& deliveryId,
        const std::vector<NMdbSave::TMdbSaveResponseRcptNode>& rcpts);

}
