#include "mthr.h"

#include "common.h"

#include <mail/notsolitesrv/src/util/optional.h>

namespace NNotSoLiteSrv::NMetaSaveOp {

using NUtil::ConvertOptional;

NMthr::TMthrRequest MakeMthrRequest(const TRequest& request) {
    NMthr::TMthrRequest mthrRequest;
    if (!request.message.from.empty()) {
        mthrRequest.HdrFromDomain = request.message.from.front().Domain;
    }

    mthrRequest.Subject = request.message.subject;
    mthrRequest.MsgTypes = request.types;
    mthrRequest.MessageId = request.message.message_id;
    mthrRequest.References = ConvertOptional(request.message.references);
    mthrRequest.InReplyTo = ConvertOptional(request.message.in_reply_to);
    mthrRequest.DomainLabel = ConvertOptional(request.domain_label);

    return mthrRequest;
}

}
